/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

/*

This shader distorts a 2D space while maintaining
monotonicity, by using Hermite interpolation with
factors up to 3.

Thanks to Reedbeta for the suggestion.

--
Zavie

*/

// For scenes using a background image as the texture input for
// this shader were very slow to start,  though  they  then ran
// smoothly. However, by changing the functions  to  equivalent
// macros eliminated the trouble. TheEmu.

// float h00(float x) { return 2.*x*x*x - 3.*x*x + 1.; }
// float h10(float x) { return x*x*x - 2.*x*x + x; }
// float h01(float x) { return 3.*x*x - 2.*x*x*x; }
// float h11(float x) { return x*x*x - x*x; }

#define h00(x) ( 2.*x*x*x - 3.*x*x + 1. )
#define h10(x) ( x*x*x - 2.*x*x + x     )
#define h01(x) ( 3.*x*x - 2.*x*x*x      )
#define h11(x) ( x*x*x - x*x            )

float Hermite(float p0, float p1, float m0, float m1, float x)
{
	return p0*h00(x) + m0*h10(x) + p1*h01(x) + m1*h11(x);
}

void main(void)
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;

	float a = sin(iGlobalTime * 1.0)*0.5 + 0.5;
	float b = sin(iGlobalTime * 1.5)*0.5 + 0.5;
	float c = sin(iGlobalTime * 2.0)*0.5 + 0.5;
	float d = sin(iGlobalTime * 2.5)*0.5 + 0.5;
	
	float y0 = mix(a, b, uv.x);
	float y1 = mix(c, d, uv.x);
	float x0 = mix(a, c, uv.y);
	float x1 = mix(b, d, uv.y);

	uv.x = Hermite(0., 1., 3.*x0, 3.*x1, uv.x);
	uv.y = Hermite(0., 1., 3.*y0, 3.*y1, uv.y);

	// Modified to preseve transparency. TheEmu.

	vec4 color = texture2D(iChannel0, vec2(uv.x, 1. - uv.y));
	vec2 grid = fract(0.25*iResolution.xy*uv); // Changed 0.05 to 0.25. TheEmu

   color.rgb = mix(0.8, 1., 0.5*(grid.x + grid.y))*color.rgb;
	gl_FragColor = color;

}
